package edu.columbia.cs.itx.dsadmin;

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.table.*;
import cnrg.itx.ds.*;

public class DSUserManager extends Object implements ActionListener {
  DSUserManager_Add addUserManager;
  JTable usersTable;
  TableModel sorter;
  TableModel usersTableModel;
  Frame owner;
  DirectoryService ds;
  
  public DSUserManager(Frame owner, JTable usersTable, DirectoryService ds) throws DSUserManagerException {
    if (usersTable != null && ds != null) {
      this.owner = owner;
      this.ds = ds;
      this.usersTable = usersTable;
      sorter = usersTable.getModel();
      usersTableModel = ((TableMap)sorter).getModel();
    }
    else
      throw new DSUserManagerException("Table or DirectoryService cannot be null.");
  }

  public void actionPerformed(ActionEvent e) {
    AbstractButton source = (AbstractButton)e.getSource();
    String text = source.getText();
    if (text.equals("Add User")) {
      addUserManager = new DSUserManager_Add();
    } else if (text.equals("Remove User")) {
      removeUser();
    }
  }

  // get the user to remove and remove him/her
  public void removeUser() {
    int selectedRow = usersTable.getSelectedRow();
    if (selectedRow == -1)
      JOptionPane.showMessageDialog(owner, "Please select a user to remove.", "User Not Selected", JOptionPane.WARNING_MESSAGE);
    else {
      String userID = (String)sorter.getValueAt(selectedRow, 0);
      String ext = (String)sorter.getValueAt(selectedRow, 1);
      int retval = warning(userID, ext);
      if (retval == JOptionPane.YES_OPTION) {
        try {
          ds.removeUser(new Digits(ext));
          dataUpdated();
        } catch (Exception e) {
          e.printStackTrace();
        }
      }
    }
  }

  // warning when removing a user
  public int warning(String userID, String ext) {
    String msg = "Are you sure you want to remove user " + userID + " with extension " + ext + "?";
    return JOptionPane.showConfirmDialog(owner, msg, "Warning! About to remove a user.", JOptionPane.YES_NO_OPTION, JOptionPane.WARNING_MESSAGE);
  }

  // update the table if the data are updated
  public void dataUpdated() {
    try {
      Vector users = ds.dumpAllUsers();
      ((DSTableModel)usersTableModel).setUsers(users);
    } catch (Exception e) {
      e.printStackTrace();
    }
  }

  class DSUserManager_Add extends Object implements ActionListener {
    UserEditorDialog userEditorDialog;

    public DSUserManager_Add() {
      userEditorDialog = new UserEditorDialog(owner, "Add a User", false);
      userEditorDialog.addAddButtonActionListener(this);
      userEditorDialog.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
      String id = userEditorDialog.getID();
      String ext = userEditorDialog.getExtension();
      String pass1 = userEditorDialog.getPassword();
      String pass2 = userEditorDialog.getVerifyingPassword();
      String custMsg = userEditorDialog.getCustomMessage();
      int accessLevel;

      if (pass1.equals(pass2)) {
        switch(userEditorDialog.getAccessLevelListIndex()) {
          case 2: accessLevel = DirectoryService.ADM_ACCESS_LEVEL;
                  break;
          case 1: accessLevel = DirectoryService.SERVER_ACCESS_LEVEL;
                  break;
          case 0:
          default: accessLevel = DirectoryService.USER_ACCESS_LEVEL;
        }
        try {
          ds.addUser(new UserID(id), new Digits(ext), new Password(pass1), accessLevel, custMsg);
          dataUpdated();
        } catch (RecordAlreadyExistsException e1) {
          String msg = "User with extension " + ext + " already exists.";
          JOptionPane.showMessageDialog(owner, msg, "Error: Duplicate User", JOptionPane.WARNING_MESSAGE);
        } catch (Exception e2) {
          e2.printStackTrace();
        }
      }
      else {
        JOptionPane.showMessageDialog(owner, "Invalid password!", "Invalid Password", JOptionPane.WARNING_MESSAGE);
      }
      userEditorDialog.dispose();
      userEditorDialog = null;
    }
  } // end of DSUserManager_Add
}
